//
//  LogoViewController.m
//  Logo
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "LogoViewController.h"

@implementation LogoViewController

@synthesize imageView;


// init
- (void)viewDidLoad {

	// prepare the data
	data = [[NSMutableData alloc] init];

	// load the image
	NSURL *url = [NSURL URLWithString:@"http://hci.rwth-aachen.de/img/wiki_up/i10Logo_rgba_small.png"];
	NSURLRequest *request = [NSURLRequest requestWithURL:url];
	NSURLConnection *connection = [NSURLConnection connectionWithRequest:request delegate:self];
	[connection start];
}


#pragma mark NSURLConnectionDelegate

// connection did load a chunk of data
- (void)connection:(NSURLConnection *)connection didReceiveData:(NSData *)newData
{
	[data appendData:newData];
}

// connection is done loading data
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
	// create an image form the data
	UIImage *image = [UIImage imageWithData:data];
	
	// display the image
	self.imageView.image = image;
	
	[data release];
	data = nil;
}


#pragma mark Memory management

// cleanup
- (void) dealloc
{
	[data release];
	[super dealloc];
}


@end
